<?php

extract( shortcode_atts( array(
	'style' => 'with-image1',
	'price' => '',
	'image' => '',
	'show_padding' => 'no',
	'image_border_color' => '',
	'price_color' => '',
	'price_bg_color' => '',
	'fontsize' => '',
	'textcolor' => '',
	'el_class' => '',
), $atts ) );

$id = sm_shortcode_unique_id( "sm-catalogue-item" );
$css_gen = new Inline_CSS_Generator( "sm-catalogue-item", $id );

$css_class = array( 'sm-catalogue-item' );
$css_class[] = 'sm-style-' . $style;
$css_class[] = 'sm_content_element';
if( $show_padding == 'yes' ) {
	$css_class[] = 'sm-image-show-padding'; 
}
if( $image ) {
	$css_class[] = 'sm-image-exists';
}

$scoped_css = '';
if( $style == 'simple' ) {
	$fontsize_num = intval( $fontsize );
	if( $fontsize_num > 0 ) {
		$scoped_css .= $css_gen->css( '.content-wrapper', array(
			'font-size' => $fontsize_num . 'px', 	
		) );
	}
	if( $textcolor ) {
		$scoped_css .= $css_gen->css( '.content-wrapper', array(
			'color' => $textcolor,	
		) );
	}
}
if( $style == 'with-image1' ) {
	if( $image_border_color ) {
		$scoped_css .= $css_gen->css_with_self_condition( '.sm-style-with-image1.sm-image-exists.sm-image-show-padding', '.image-size-wrapper', array(
			'border-color' => $image_border_color,
		) );
	}
	if( $price_color ) {
		$scoped_css .= $css_gen->css_with_self_condition( '.sm-style-with-image1', '.content-wrapper .price', array(
			'color' => $price_color,
		) );
	}
	if( $price_bg_color ) {
		$scoped_css .= $css_gen->css_with_self_condition( '.sm-style-with-image1', '.content-wrapper .price', array(
				'background-color' => $price_bg_color,
		) );
	}
}

echo "<div id='" . esc_attr( $id ) . "' class='" . esc_attr( implode( ' ', $css_class ) ) . "'>";

if( $scoped_css ) {
	echo "<style scoped>" . $scoped_css . "</style>";
}

if( $image ) {
	$image_url = wp_get_attachment_thumb_url( $image );
	echo "<div class='image-wrapper'>";
	echo "<div class='image-size-wrapper'>";
	echo "<div class='image-div' style='background-image: url(\"" . esc_url( $image_url ) . "\")'></div>";
	echo "<img class='hidden' src='" . esc_url( $image_url ) . "' alt='Catalogue image'>";
	echo "</div>";
	echo "</div>";
}

echo "<div class='content-wrapper'>";
echo "<div class='content'>" . $content . "</div>";
if( $style == 'simple' ) {
	echo "<div class='separator'></div>";
}
echo "<div class='price'><span>" . esc_attr( $price ) . "</span></div>";
echo "</div>";

echo "</div>";